# 1) خلاصهٔ محصول (Reality Check)

**حاجی = نمایشگاه دیجیتال + مشاور همیشه‌آنلاین** برای کاسب/نمایشگاه‌دار/دلال.

هستهٔ ارزش:  **فرصت‌های روز + قیمت‌یارِ قابل‌دفاع + تمرین مذاکرهٔ واقعی + پاسخ حقوقی/کارشناسی در لحظه** .

زیرساخت:  **Laravel 10 + MySQL (cPanel)** ، **OpenAI Responses API** با  **file_search (Vector Store)** ، پرداخت  **زرین‌پال** ، دادهٔ آگهی از **majidapi** (باما/دیوار).

 **بدون citation به کاربر** . همهٔ چت‌بات‌ها RAG دارند (VS اصلی مشترک)،  **اینستاگرام VS مجزا** .

---

# 2) اهداف و سنجه‌ها

* North Star: **#فرصت‌های «به‌قیمت» دیده‌شده که منجر به اقدام شد / کاربر / هفته**
* Activation D1 ≥ 60% (اولین قیمت‌یار/تمرین/چک‌لیست)
* CTR «فرصت‌های امروز» ≥ 25%، ذخیرهٔ آگهی ≥ 10%
* Latency پاسخ AI ≤ 2.5s در ۸۰% موارد
* نرخ موفقیت پرداخت ≥ 98%

---

# 3) منوی تلگرام (ثابت، ساده، قابل‌ویرایش از پنل)

* 🔎 **فرصت‌های امروز** (Push انتخابی)
* 💸 **آگهی‌های به قیمت** *(جدید)*
* 💰 **قیمت‌یار**
* 🗣️ **تمرین مذاکره و فروش** (سناریو + Q&A هدایت‌گر)
* 🛠️ **سؤالات کارشناسی** (+ **کارشناسی‌یار** چک‌لیستی)
* ⚖️ **سؤال حقوقی**
* 🧾 **قولنامه آماده** *(دو فایل ثابت: خرید/فروش)*
* 🔧 **بازدید ۳ دقیقه‌ای** *(چک‌لیست حین معامله: خرید/فروش)*
* 🏙️ **گزارش شهر من**
* ✍️ **ایده/کپشن/هشتگ (اینستاگرام)** *(VS مجزا)*
* 📘 **راهنما** *(جدید)*
* 👤 **حساب من**
* 💳 **پرداخت/اشتراک**
* 🆘 **پشتیبانی**

**Onboarding (۶۰–۹۰ث):** نقش (نمایشگاه‌دار/دلال/تازه‌کار) → شهر/استان → بازهٔ بودجه (۳ سطح) → فرکانس پیام (کم/معمولی/زیاد) → تایید قوانین کوتاه → پایان.

---

# 4) معماری کلان

## 4.1 لایه‌ها

* **App (Laravel 10, PHP 8.2, MySQL/cPanel)**

  * Telegram SDK: `defstudio/telegraph` یا `irazasyed/telegram-bot-sdk`
  * Queue: Database Queue + Cron هر دقیقه
  * PDF (برای فاکتور/چاپ ثابت): `barryvdh/laravel-dompdf`
  * Payment: `shetabit/payment` (زرین‌پال)
  * Admin Panel: `filament/filament` + `spatie/laravel-permission`
* **AI Provider Layer (قابل‌تعویض)**

  <pre class="overflow-visible!" data-start="2814" data-end="2909"><div class="contain-inline-size rounded-2xl relative bg-token-sidebar-surface-primary"><div class="sticky top-9"><div class="absolute end-0 bottom-0 flex h-9 items-center pe-2"><div class="bg-token-bg-elevated-secondary text-token-text-secondary flex items-center gap-4 rounded-sm px-2 font-sans text-xs"></div></div></div><div class="overflow-y-auto p-4" dir="ltr"><code class="whitespace-pre! language-php"><span><span>interface</span><span></span><span>LlmProvider</span><span> { </span><span>public</span><span></span><span>function</span><span></span><span>respond</span><span>(</span><span>LlmRequest $req</span><span>): </span><span>LlmResponse</span><span>; }
  </span></span></code></div></div></pre>

  * `OpenAiProvider` (فعلی): **Responses API** + **file_search**
  * `OpenRouterProvider` (غیرفعال فعلاً): اضافه‌شدنی بدون تغییر فیچرها
* **RAG (OpenAI Vector Stores)**

  * **VS_MAIN** : دانش «هوش خودرو/حقوق/کارشناسی/مذاکره/…» (مشترک همهٔ چت‌بات‌ها)
  * **VS_IG** : دانش تخصصی اینستاگرام (سناریو/کپشن/هشتگ)

## 4.2 الگوی پاسخ (Memory + RAG)

* **حافظهٔ مکالمه** : `store: true` + استفاده از `previous_response_id` به‌ازای هر Thread (user+module).
* **RAG** : در هر کال، `tool_resources.file_search.vector_store_ids = [VS_MAIN]` (یا VS_IG).
* **مدل به‌ازای ماژول** از پنل انتخاب می‌شود (پیش‌فرض:  **gpt-4o-mini** ).
* **Structured Output** در ماژول‌هایی مثل «قیمت‌یار».

---

# 5) جریان «دریافت و پخش آگهی‌ها»

## 5.1 منابع و API‌ها (majidapi)

**باما**

* لیست تازه‌ها: `GET https://api.majidapi.ir/bama?action=latest&page=1`
* جستجو: `GET https://api.majidapi.ir/bama?action=search&s=mvm&page=1`
* جزئیات: `GET https://api.majidapi.ir/bama?action=details&code=CODE`
* قیمت خودرو: `GET https://api.majidapi.ir/bama?action=carPrice&brand=arisun`
* قیمت موتور: `GET https://api.majidapi.ir/bama?action=motorcyclePrice&brand=benelli`

**دیوار** (Scraper)

* `GET https://api.majidapi.ir/tools/scraper?url=…&className=…&id=…`
  * برای هر شهر/مدل، **Scrape Profile** قابل‌تنظیم در پنل (URL پایه، کلاس/ID هدف).

## 5.2 Jobها و زمان‌بندی

* `BamaPullLatestJob` (هر 5–10 دقیقه): صفحات 1..N (N از پنل)
* `BamaSearchJob`: کلیدواژه‌های اولویت‌دار (برند/مدل)
* `BamaDetailsJob`: تکمیل رکوردهای ناقص با `details&code`
* `DivarScrapeJob`: اجرای Profileهای تعریف‌شده (شهر/مدل)
* **Backoff/Retry** هوشمند + **Health Metrics** (نرخ موفق/شکست، latency)

## 5.3 نرمال‌سازی، Dedup، Enrichment

* **Normalizer** : تبدیل به اسکیمای داخلی واحد:

  `source, code, brand, model, trim, year, km, city, price, body_status, link, contact_ref, ts_posted`
* **جداول مرجع** : `brands(models)`, `cities(aliases)`, `body_status_map`
* **Dedup** :
* کلید اصلی: `source + code`
* پشتیبان: hash `(brand, model, year, km, city, price)`
* **Enrichment (امتیاز و دلیل)** :
* محاسبهٔ شاخص «به‌قیمت»:

  * روش ۱ (ساده): مقایسه با **میانهٔ شهر** (اگر به‌دست آید)
  * روش ۲ (fallback): **قواعد قابل‌تنظیم** (حداکثر کارکرد/سال/رنگ/… → امتیاز)
* تولید **2 دلیل کوتاه** (قابل‌ویرایش در پنل)
* ذخیره در `opportunities` با `score` و `reasons_json`.

## 5.4 «فرصت‌های امروز» (Push انتخابی)

* ادمین در پنل → لیست فرصت‌ها → ادیت/اولویت → **Push** به سگمنت (نقش/شهر/فرکانس).
* کارت شامل: عنوان، شهر، سال/کارکرد، قیمت، **۲ دلیل کوتاه** + دکمه‌ها:
  * «💰 قیمت‌یار»، «🗣️ تمرین مذاکره»، «🔧 بازدید ۳دقیقه‌ای»، «⭐ ذخیره»
* سیاست قیمت: در صورت نیاز **بازه/شاخص** به‌جای عدد قطعی.

## 5.5 **آگهی‌های به قیمت** (دکمهٔ مستقل — جدید)

* فشردن دکمه: **لیست آگهی‌های «معقول» شهر کاربر** (۷–۱۰ تایی) با:
  * عنوان خلاصه، قیمت، سال/کارکرد، شهر،  **۲ دلیل کوتاه** ، و **لینک مستقیم** به آگهی در دیوار/باما
* معیار «معقول»:
  * اگر میانه/پراکندگی شهر موجود باشد: آگهی‌های داخل «بازهٔ قابل‌قبول» (Config از پنل: مثلاً -۱۰% تا -۲۵% نسبت به میانه)
  * اگر دادهٔ کافی نیست: قواعد fallback (مثلاً کارکرد < X، سال > Y، وضعیت بدنه OK)
* صفحه‌بندی با  **Next/Prev** ؛ قابلیت **ذخیره** هر آگهی.

## 5.6 **آگهی ویژه** (اختصاصی خودمان — جدید)

* پنل: ادمین می‌تواند **Featured Ad** بسازد (عنوان، توضیح کوتاه، قیمت/شرایط، لینک، شهر/نقش هدف).
* ارسال **Push** جداگانه با  **برچسب «آگهی ویژه»** .
* ذخیرهٔ عملکرد: نرخ بازکردن/کلیک/ذخیره.

---

# 6) طراحی چت‌بات‌های ماژولی (همه RAG دارند)

## 6.1 💰 قیمت‌یار (Structured Output)

* ورودی: برند/مدل، سال، کارکرد، شهر، وضعیت بدنه/رنگ
* خروجی JSON: `min, max, anchor, confidence ∈ {low,medium,high}, reasons[3]`
* Normalisation: digits FA/EN, Jalali↔Gregorian years, stop-word stripping (مثل «مدل»)
* Data sources: MajidAPI `carPrice` (رسمی) + multi-query ads search/`latest`
* Prompt (System): کوتاه، عملی؛ در ابهام بازه + هشدار؛ **بدون ارجاع** و **بدون CTA/دعوت به تماس**
* Policy: خروجی متنی فقط بازه، لنگر، اعتماد و دلایل کوتاه است؛ هیچ دعوت به تماس/خریدی وجود ندارد.
* RAG: VS_MAIN (`file_search`)
* رندر کارت تلگرام: بازه + Anchor + اطمینان + ۳ دلیل (بولت کوتاه)
* Thread: `valuation` (حافظهٔ رشته)

## 6.2 🗣️ تمرین مذاکره و فروش (سناریو + Q&A هدایت‌گر)

* حالت ۱:  **سناریو آماده** —۳ شروع (مودب/قاطع/حقوقی) + ۳ اعتراض رایج با پاسخ
* حالت ۲:  **Q&A واقعی** —کاربر وضعیت واقعی‌اش را می‌گوید؛ حاجی:
  * **سؤال‌های هدایت‌گر** (برای جمع‌آوری جزئیات)،
  * **دیالوگ پیشنهادی کوتاه** ،
  * **پلن اقدام** ۳مرحله‌ای.
* Prompt (System): «کوچ فروش»؛ اول Action، بعد دلیل؛ لحن محترم/رک
* RAG: VS_MAIN (مذاکره/متقاعدسازی)
* Thread: `negotiation` (حفظ جریان تمرین)

## 6.3 🛠️ سؤالات کارشناسی + **کارشناسی‌یار**

* Q&A کارشناسی: پاسخ بولتی (ایرادهای رایج مدل/سال + «چطور بفهمم؟»)
* **کارشناسی‌یار** (Flow خرید/فروش):
  * کاربر: «روی خودروی X هستم» → حاجی چک‌لیست تخصصی (در پرامپت/پنل) را مرحله‌به‌مرحله راه می‌برد:
    * بدنه/رنگ → آزمون‌های سریع میدانی
    * موتور/گیربکس → نشانه‌ها/صداهـا
    * اسناد/VIN → کنترل‌های لازم
  * خروجی: **ریسک‌مپ** (سبز/زرد/قرمز) + «قدم بعد» (قیمت‌یار/مذاکره/انصراف)
* RAG: VS_MAIN
* Thread: `inspection`

## 6.4 ⚖️ سؤال حقوقی

* پاسخ کوتاه و **بولت‌وار** + هشدارهای مهم (زبان ساده)
* RAG: VS_MAIN (بخش حقوقی/قرارداد)
* Thread: `legal`
* دیسکلیمر کوتاه (متن ثابت از پنل)

## 6.5 🧾 قولنامهٔ آماده (دو فایل ثابت — جدید)

* در پنل **دو فایل ثابت** (PDF/Doc) می‌گذاریم: **قولنامهٔ خرید** و **قولنامهٔ فروش**
* در ربات، کاربر **انتخاب می‌کند و فایل را دریافت/چاپ** می‌کند.
* (دیگر تولید PDF دینامیک لازم نیست؛ فقط سرو فایل)

## 6.6 🔧 بازدید ۳ دقیقه‌ای (چک‌لیست حین معامله — جدید)

* **دو مسیر جدا** : برای **خرید** و برای **فروش**
* هر مسیر: ۸–۱۰ سؤال کوتاه → **ریسک‌مپ** + «قدم بعدی» پیشنهادی
* RAG: VS_MAIN (کارشناسی/معامله)
* Thread: `inspection` (همان کانال)

## 6.7 🏙️ گزارش شهر من (هفتگی)

* ۳ نکتهٔ مهم هفته، ۳ مدل پرمعامله، توصیهٔ اقدام
* CTA: قیمت‌یار همین مدل، تمرین مذاکره، ذخیره برای مشتری
* RAG: VS_MAIN (در صورت وجود محتوای روندی) + دادهٔ داخلی فرصت‌ها

## 6.8 ✍️ ایده/کپشن/هشتگ (اینستاگرام — VS جدا)

* خروجی: **سناریو** (موضوع/زاویه/CTA)،  **۲–۳ کپشن کوتاه** ، **۱۰ هشتگ**
* RAG: **VS_IG** (دانش IG)
* Thread: `instagram`

## 6.9 📘 راهنما (جدید)

* پیام‌های چندبخشی:
  * «حاجی چه می‌کند؟»
  * «هر دکمه چه خروجی می‌دهد؟»
  * «اولین گام‌ها: قیمت‌یار/تمرین/چک‌لیست»
  * «سوالات پرتکرار»
* از پنل قابل‌ویرایش؛ **میان‌بُرها** به دکمه‌های مربوطه.

---

# 7) پنل ادمین (Filament) — کنترل کامل

* **منوها** : عنوان/ایموجی/ترتیب/نقش/فعال-غیرفعال
* **Prompts & Models** :
* به‌ازای هر ماژول: system prompt، user template، **انتخاب مدل OpenAI** (پیش‌فرض: gpt-4o-mini)، پارامترها (temp/top_p)، **فعال/غیرفعال file_search**
* **Vector Stores** :
* ثبت VS_MAIN و VS_IG (شناسه‌ها)
* Attach/Detach فایل‌های OpenAI Storage
* نمایش وضعیت پردازش (in_progress → completed)
* **Tag** برای اسناد VS_MAIN (legal/valuation/inspection/negotiation/…)
* **فرصت‌ها (Opportunities)** :
* لیست ورودی‌ها از Jobها، ادیت/دلایل/امتیاز، وضعیت انتشار: draft → reviewed → scheduled → sent
* **آگهی ویژه** : ساخت/ویرایش/انتشار (سگمنت/شهر/نقش)
* **آگهی‌های به قیمت** : پارامترهای الگوریتم (threshold درصدی، حداقل دادهٔ شهر، قواعد fallback)
* **قولنامه** : مدیریت **دو فایل ثابت** (خرید/فروش)
* **چک‌لیست‌ها** : مدیریت سؤالات/بخش‌ها برای خرید/فروش (کارشناسی‌یار/بازدید)
* **اشتراک/پرداخت** : یک پلن (مدت/قیمت/تخفیف/کوُتاها)، لاگ پرداخت/verify، reconcile
* **کاربران** : نقش/شهر/فرکانس پیام/وضعیت اشتراک
* **Feature Flags** : خاموش/روشن ماژول‌ها هنگام Incident
* **Test Prompt** : اجرای آزمایشی هر پرامپت با ورودی نمونه (sandbox)

---

# 8) دیتابیس (MySQL) — اسکیمای کلیدی

**Users & Access**

* `users(id, tg_id, role, city, plan, notif_level, created_at, updated_at)`
* `subscriptions(id, user_id, plan, starts_at, ends_at, status)`
* `payments(id, user_id, gateway, ref, amount, status, payload_json, created_at)`

**Menu / Prompts / Models / Vector Stores**

* `menu_items(id, key, title, emoji, enabled, ord, visible_roles, updated_at)`
* `prompt_configs(id, module, model, temperature, top_p, enable_file_search, updated_at)`
* `vector_stores(id, name, openai_vector_store_id, is_active, created_at)`
* `vector_files(id, vector_store_id, openai_file_id, tag, status, created_at)`  // tag برای domain

**Ads & Opportunities**

* `ads_raw(id, source, payload_json, fetched_at)`
* `opportunities(id, source, code, brand, model, trim, year, km, city, price, body_status, link, contact_ref, dedup_key, score, reasons_json, status, ts_posted, pushed_at, created_at)`
* `featured_ads(id, title, description, price, city, link, target_roles, target_cities, scheduled_at, pushed_at, status)`
* `scrape_profiles(id, name, url, class_name, element_id, city, keywords, enabled)`

**Content & Checklists**

* `legal_files(id, type /*buy|sell*/, file_path, updated_at)`
* `checklists(id, name, type /*inspection_buy|inspection_sell*/, questions_json, updated_at)`
* `city_reports(id, city, week_no, summary_json, created_at)`

**Chat & Memory**

* `chat_threads(id, user_id, module, last_response_id, expires_at, created_at, updated_at)`
* `chats(id, user_id, module, role, text, response_id, token_in, token_out, created_at)`
* `events(id, user_id, type, payload_json, created_at)`  // open_digest, opportunity_view, valuation_done, …

---

# 9) ادغام OpenAI Responses (الگوی مشترک)

**ویژگی‌ها:**

* `store: true` برای هر پاسخ → حافظهٔ سروری
* اگر Thread جاری داریم: `previous_response_id`
* `tool_resources.file_search.vector_store_ids = ["VS_MAIN"]` (یا VS_IG)
* `response_format` برای JSONهای ساختاری (مثل قیمت‌یار)
* **بدون citation** در خروجی کاربر

**کال نمونه (قیمت‌یار):**

<pre class="overflow-visible!" data-start="12258" data-end="13041"><div class="contain-inline-size rounded-2xl relative bg-token-sidebar-surface-primary"><div class="sticky top-9"><div class="absolute end-0 bottom-0 flex h-9 items-center pe-2"><div class="bg-token-bg-elevated-secondary text-token-text-secondary flex items-center gap-4 rounded-sm px-2 font-sans text-xs"></div></div></div><div class="overflow-y-auto p-4" dir="ltr"><code class="whitespace-pre! language-json"><span><span>{</span><span>
  </span><span>"model"</span><span>:</span><span></span><span>"gpt-4o-mini"</span><span>,</span><span>
  </span><span>"store"</span><span>:</span><span></span><span>true</span><span></span><span>,</span><span>
  </span><span>"previous_response_id"</span><span>:</span><span></span><span>"resp_123"</span><span>,</span><span>
  </span><span>"tool_resources"</span><span>:</span><span></span><span>{</span><span></span><span>"file_search"</span><span>:</span><span></span><span>{</span><span></span><span>"vector_store_ids"</span><span>:</span><span></span><span>[</span><span>"VS_MAIN"</span><span>]</span><span></span><span>}</span><span></span><span>}</span><span>,</span><span>
  </span><span>"input"</span><span>:</span><span></span><span>[</span><span>
    </span><span>{</span><span></span><span>"role"</span><span>:</span><span></span><span>"system"</span><span>,</span><span></span><span>"content"</span><span>:</span><span></span><span>"[SYSTEM PROMPT: valuation-fa]"</span><span></span><span>}</span><span>,</span><span>
    </span><span>{</span><span></span><span>"role"</span><span>:</span><span></span><span>"user"</span><span>,</span><span></span><span>"content"</span><span>:</span><span></span><span>"206 تیپ 2، 1399، 85هزار، تهران؛ بازه و 3 دلیل بده."</span><span></span><span>}</span><span>
  </span><span>]</span><span>,</span><span>
  </span><span>"response_format"</span><span>:</span><span></span><span>{</span><span>
    </span><span>"type"</span><span>:</span><span></span><span>"json_object"</span><span>,</span><span>
    </span><span>"schema"</span><span>:</span><span></span><span>{</span><span>
      </span><span>"type"</span><span>:</span><span></span><span>"object"</span><span>,</span><span>
      </span><span>"properties"</span><span>:</span><span></span><span>{</span><span>
        </span><span>"min"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"number"</span><span>}</span><span>,</span><span>
        </span><span>"max"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"number"</span><span>}</span><span>,</span><span>
        </span><span>"anchor"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"number"</span><span>}</span><span>,</span><span>
        </span><span>"confidence"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"string"</span><span>,</span><span></span><span>"enum"</span><span>:</span><span></span><span>[</span><span>"low"</span><span>,</span><span>"medium"</span><span>,</span><span>"high"</span><span>]</span><span>}</span><span>,</span><span>
        </span><span>"reasons"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"array"</span><span>,</span><span></span><span>"items"</span><span>:</span><span></span><span>{</span><span>"type"</span><span>:</span><span></span><span>"string"</span><span>}</span><span>}</span><span>
      </span><span>}</span><span>,</span><span>
      </span><span>"required"</span><span>:</span><span></span><span>[</span><span>"min"</span><span>,</span><span>"max"</span><span>,</span><span>"confidence"</span><span>,</span><span>"reasons"</span><span>]</span><span>
    </span><span>}</span><span>
  </span><span>}</span><span>
</span><span>}</span><span>
</span></span></code></div></div></pre>

---

# 10) الگوریتم «به‌قیمت» (Configurable)

* **مسیر A (وقتی دادهٔ شهر کافی است):**
  * محاسبهٔ **میانهٔ قیمت** برای `(brand, model, city)` از آخرین N آگهی معتبر
  * انتخاب آگهی‌هایی با **انحراف منفی** در بازهٔ پیکربندی (مثلاً -۱۰% تا -۲۵%)
* **مسیر B (fallback):**
  * قواعد سادهٔ پنلی:
    * `year >= Ymin`، `km <= Kmax`، `body_status in {ok, minor}`، قیمت زیر `X`
* **امتیازدهی و دلایل:**
  * Score ترکیب‌شده از انحراف قیمت + سال/کارکرد/وضعیت بدنه
  * **۲ دلیل کوتاه** (مثلاً «کم‌کار»، «سال ۱۴۰۰»، «محله کم‌ریسک»)
* **TTL:** آگهی قدیمی (> 72h) → کنار گذاشته یا برچسب «قدیمی»
* **لینک مستقیم:** همیشه همراه آگهی (دیوار/باما)

---

# 11) پرداخت/اشتراک (زرین‌پال)

* یک پلن (ماهانه/فصلی) — قیمت را بعداً از پنل تنظیم می‌کنی
* Flow: صدور فاکتور → درگاه → `/payments/verify` → فعال‌سازی اشتراک → رسید در چت
* **Quota per module** قابل‌پیکربندی (برای کنترل هزینهٔ توکن و بار)

---

# 12) امنیت/پایداری/عملیات

* کلیدها در `.env` (سرور)
* Rate-limit: ۵ req/min/کاربر
* Timeout LLM: ۲۰s + Retry ۱بار
* Health:
  * majidapi success%/latency
  * Queue depth
  * OpenAI latency/error%
* Incident: Feature Flags (خاموش/روشن سریع یک ماژول)
* Backups: DB روزانه + Export تنظیمات پنل/VectorStore IDs

---

# 13) UX و متن‌ها (لحن و الگو)

* **کوتاه، رک، عملی** ؛ اول «اقدام بعدی»، بعد دلیل
* اعداد و واحدها فارسی/قابل‌خواندن (۱۲۰٬۰۰۰ کیلومتر / تومان)
* پیام خطا/ابهام: محترمانه + راه‌حل (مثلاً «دادهٔ کافی نیست؛ مشخصات بیشتری بده…»)
* **راهنما** : توضیح سادهٔ هر دکمه + مسیرهای «شروع سریع»

---

# 14) تست و پذیرش (Acceptance)

* **فرصت‌های امروز** : Pull→Normalize→Dedup→Review→Push؛ CTR ≥ 25% هفتهٔ اول
* **آگهی‌های به قیمت** : دکمه ارسال ۷–۱۰ مورد معقول شهر + لینک؛ صفحه‌بندی + ذخیره
* **آگهی ویژه** : ساخت در پنل → Push به سگمنت؛ نرخ کلیک قابل‌ثبت
* **قیمت‌یار** : خروجی JSON معتبر؛ latency ≤ 2.5s در ۸۰%
* **تمرین مذاکره** : Q&A هدایت‌گر + پلن اقدام ۳مرحله‌ای؛ Thread پایدار
* **کارشناسی‌یار** : چک‌لیست خرید/فروش → ریسک‌مپ + «قدم بعدی»
* **سؤال حقوقی** : پاسخ بولتی کوتاه، دیسکلیمر ثابت
* **قولنامه** : دو فایل ثابت سرو می‌شود (دانلود/چاپ)
* **پرداخت** : verify موفق → اشتراک فعال در «حساب من»
* **پنل** : انتخاب مدل به‌ازای هر ماژول + Test Prompt + Attach/Detach فایل‌های VS

---

# 15) برنامهٔ اجرا (۴ هفته، تیم یک‌نفره با Cursor)

**هفته ۱**

* اسکیمای DB + Seeder (منو/پرامپت/کانفیگ‌ها/چک‌لیست‌ها)
* تلگرام SDK + وبهوک + روت منوها
* Filament: Users, Menu, Prompts, VectorStores, Payments
* زرین‌پال: صدور/verify + «حساب من»
* Scrape Profiles پایه (دیوار)

**هفته ۲**

* LlmProvider + OpenAiProvider (Responses + file_search + memory)
* ماژول‌ها: فرصت‌های امروز (Jobs + Review/Push)، آگهی‌های به قیمت (فیلتر/صفحه‌بندی)، آگهی ویژه
* ذخیرهٔ چت + usage + response_id؛ Thread ماژول‌محور

**هفته ۳**

* قیمت‌یار (JSON ساختاری)، تمرین مذاکره (سناریو + Q&A)، سؤالات کارشناسی + کارشناسی‌یار
* سؤال حقوقی، بازدید ۳ دقیقه‌ای (چک‌لیست خرید/فروش)، گزارش شهر
* قولنامه (دو فایل ثابت) + راهنما

**هفته ۴**

* Attach/Detach فایل‌های VS_MAIN و VS_IG از پنل؛ مانیتور in_progress
* استرس‌تست Jobها/Rate-limit/Timeout/Retry
* داشبورد KPI + گزارش روزانه + Feature Flags
* تست‌های حداقلی (webhook/payments/jobs/AI call) و لانچ پایلوت ۵۰نفره، سپس rollout
